'use strict';

/* Controllers */
var NotaryCtrl = ['$scope', '$rootScope', '$location', '$route', '$window', 'FrontCreatorCompanyForLoggedUser', 'FrontCreatorCompanyConfirmStage', function($scope, $rootScope, $location, $route, $window, FrontCreatorCompanyForLoggedUser, FrontCreatorCompanyConfirmStage){
    var myPlayerName = "creator_notary";
    var myPlayer = _V_(myPlayerName);
    var addCuepointForVideojs = true;
    $rootScope.$on('Tutorial:open', function(event, type){
        myPlayer.pause();
    });


    $scope.CreatorStage = $route.current.locals.creatorStage;
    $scope.companyRoleTypes = $route.current.locals.companyRoleTypes;
    $scope.Company = $route.current.locals.company;
    $scope.activeCodesPkd = $route.current.locals.activeCodesPkd;
    $scope.usersList = {}

    $scope.currentPoint = {};
    $scope.indexTokenPart = 7;
    $scope.isCheckChef = false;
    $scope.firstTimeChoosingManagement = true;
    $scope.methodType = 'creator-notary';
    $scope.namePattern = /^[\\.\s0-9a-zA-ZąćęłńóśźżĄĘŁŃÓŚŹŻ\-]+$/;
    $scope.cityPattern = /^[\\.\sa-zA-ZąćęłńóśźżĄĘŁŃÓŚŹŻ\-]+$/;

    $scope.stageDone = false;

    $scope.init = function() {
        var state = $scope.Company.creator_state;
        if(state == 1 || state == 3 || state == 5 || state == 7){
            $scope.stageDone = true;
        }

        $('#wrap').removeClass('start-page');
        var partListPlayFalse = [];
        angular.forEach($scope.CreatorStage.parts, function(part) {
            part.play = (in_array(part.index, partListPlayFalse)) ? false : true;
            part.hide = false;
        });

        var active = true;
        angular.forEach($scope.CreatorStage.steps, function(step) {
            step.active =  active;
            active = false;
        });

        angular.forEach($scope.Company.user_groups.users, function(user) {
            user.fullName = user.name+' '+user.surname;
            user.token = '';
            $scope.usersList[user.id] = user;
            if($scope.isCompanyRoleInUser(user, 'M')){
                user.checked = true;
            }
        });

        angular.forEach($scope.activeCodesPkd, function(pkd) {
            angular.forEach($scope.Company.codes_pkd, function(companyPkd) {
                if(pkd.id == companyPkd.id){
                    pkd.checked = true;
                }
            });
        });

        $scope.Company.include_chef_in_representation = false;
        $scope.isCheckChef = $scope.isUserWithCompanyRole('C');

        $scope.addCuepointForVideojs();
    }

    $scope.addCuepointForVideojs = function(){
        if(addCuepointForVideojs) {
            videojs(myPlayerName).ready(function(){
                var $this = this;
                $this.cuepoints();
                angular.forEach($scope.CreatorStage.parts, function(part){
                    $this.addCuepoint({
                        namespace: "logger",
                        start: part.end,
                        end: part.end + 0.5,
                        onStart: function(params){
                            if(params.error){
                            }else{
                                myPlayer.pause();
                                hiddenControlVideo();
                                $rootScope.$broadcast('DialogPanelNotary:show', part);
                            }
                        },
                        onEnd: function(params){
                            myPlayer.play();
                        },
                        params: {error: false}
                    });
                });
            });
            addCuepointForVideojs = false;
        }
        myPlayer.ready(function(){
            this.on("ended", function(){
                $location.path('/creator/estate');
            });
        });
    }

    $scope.resetVideo = function(){
        myPlayer.currentTime(0);
        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.$on('DialogPanelNotary:show', function(event, part){
        $scope.currentPoint = part;
        $scope.$apply();
        $(".nano").nanoScroller();
        if($scope.currentPoint.index == $scope.indexTokenPart ) {
            $scope.broadcast();
        }
    });

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType) {
            $scope.playVideo();
        }
    });

    $scope.submitForm = function(form) {
        if (form == undefined || form.$valid) {
            $scope.saveCompanyData();
//            var company = $scope.Company;
//            FrontCreatorCompanyForLoggedUser.save({data: company},function(data){
//                $scope.playVideo();
//            });
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.submitFormRepresentation = function(form) {
        if (form.$valid && $scope.Company.representation_number > 0) {
            $scope.saveCompanyData();
//            var company = $scope.Company;
//            FrontCreatorCompanyForLoggedUser.save({data: company},function(data){
//                $scope.playVideo();
//            });
        } else {
            $scope.showValidation = true;
        }
    }

    $scope.saveCompanyData = function()
    {
        var company = $scope.Company;
        FrontCreatorCompanyForLoggedUser.save({data: company},
            function(data){
                $scope.playVideo();
            },
            function(data){
                var messageText;
                if(data && data.data && data.data.message)
                    messageText = data.data.message;
                else
                    messageText = 'Wystąpił błąd kreatora';
                var message = {
                    title: "Błąd kreatora."
                    ,msg: messageText
                }

                $rootScope.$broadcast('Message:addMsg', message);
                setTimeout(function(){
                    $rootScope.$broadcast('Message:delMsg', message);
                    setTimeout(function(){
                        $window.location.reload()
//                        $location.path('/boardControlPanel/personnel');
                    }, 500);
                }, 4000);
            });
    }

    $scope.submitPkdForm = function(form) {
        $scope.validationPkd(form);
        $scope.submitForm(form);
    }

    $scope.playVideo = function(){
        if($scope.currentPoint.step_index > 0){
            var stepCurrent = -1;
            angular.forEach($scope.CreatorStage.steps, function(step){
                if(step.index == $scope.currentPoint.step_index){
                    step.done = true;
                    stepCurrent = step.index;
                }
                step.active = ((stepCurrent+1) == step.index);
            });
        }

        var nextPoint = getNextPoint($scope.currentPoint);
        if(nextPoint.hasOwnProperty('id') && !nextPoint.play) {
            myPlayer.currentTime(nextPoint.end+0.3);
            $scope.currentPoint = nextPoint;
            $scope.submitForm();
        }

        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.showPanel = function($index){
        return ($scope.currentPoint.hasOwnProperty('id') && ($index == $scope.currentPoint.index));
    }

    $scope.isSelectedPanel = function(){
        return ($scope.currentPoint.hasOwnProperty('id'));
    }

    $scope.changeSelectedMemberNumber = function(index) {
        $scope.company.memberNumber = index+1;
    }

    $scope.changeSelectedRequireNumber = function(index) {
        $scope.Company.representation_number = index+1;
    }

    $scope.checkChef = function() {
        $scope.isCheckChef = !$scope.isCheckChef;
        if(!$scope.isCheckChef){
            $scope.removeCompanyRoleInUsersAll('C');
        }
        $scope.Company.include_chef_in_representation = $scope.isCheckChef;
    }

    $scope.checkIncludeChef = function() {
        $scope.Company.include_chef_in_representation = !$scope.Company.include_chef_in_representation;
    }

    $scope.removeCompanyRoleInUser = function(user, roleSymbol) {
        angular.forEach(user.company_roles, function(role, index) {
            if(role.symbol == roleSymbol) {
                user.company_roles.splice(index, 1);
                return true;
            }
        });
    }

    $scope.removeCompanyRoleInUsersAll = function(roleSymbol) {
        angular.forEach($scope.Company.user_groups.users, function(user) {
            $scope.removeCompanyRoleInUser(user,roleSymbol);
        });
    }

    $scope.setCompanyRole = function(user, roleSymbol) {
        var index = user.company_roles.indexOf($scope.companyRoleTypes[roleSymbol]);
        if($scope.isCompanyRoleInUser(user, roleSymbol)) {
            $scope.removeCompanyRoleInUser(user, roleSymbol);
        } else {
            user.company_roles.push($scope.companyRoleTypes[roleSymbol]);
        }
    }

    $scope.setCompanyRoleManagement = function(user) {
        var roleSymbol = 'M';
        if($scope.isCompanyRoleInUser(user, roleSymbol)) {
            if(!$scope.isCompanyRoleInUser(user,'C')){
                $scope.removeCompanyRoleInUser(user, roleSymbol);
            }
        } else {
            user.company_roles.push($scope.companyRoleTypes[roleSymbol]);
        }
        user.checked = !user.checked;
        $scope.firstTimeChoosingManagement = false;
    }

    $scope.setCompanyRoleNotRemove = function(user, roleSymbol) {
        var index = user.company_roles.indexOf($scope.companyRoleTypes[roleSymbol]);
        if(!$scope.isCompanyRoleInUser(user, roleSymbol)) {
            user.company_roles.push($scope.companyRoleTypes[roleSymbol]);
        }
    }

    $scope.getCompanyRoleUserCount = function(roleSymbol) {
        var count = 0;
        angular.forEach($scope.Company.user_groups.users, function(user) {
            if($scope.isCompanyRoleInUser(user, roleSymbol)) {count++;}
        });
        return count;
    }

    $scope.isCompanyRoleInUser = function(user, roleSymbol) {
        var isRole = false;
        angular.forEach(user.company_roles, function(role) {
            if(role.symbol == roleSymbol) {
                isRole = true;
                return true;
            }
        });
        return isRole;
    }

    $scope.isUserWithCompanyRole = function(roleSymbol) {
        var isRole = false;
        angular.forEach($scope.Company.user_groups.users, function(user) {
            if($scope.isCompanyRoleInUser(user, roleSymbol)) {
                isRole = user.id;
            }
        });
        return isRole;
    }

    $scope.getUserWithCompanyRole = function(roleSymbol) {
        var userId = $scope.isUserWithCompanyRole(roleSymbol);
        if(userId > 0) {
            var selectUser = null;
            angular.forEach($scope.Company.user_groups.users, function(user) {
                if(user.id == userId) {
                    selectUser = user;
                    return;
                }
            });
            return selectUser;
        } else {
            return false;
        }
    }

    $scope.checkPkd = function(pkd){
        pkd.checked = !pkd.checked;
        if(pkd.checked){
            $scope.Company.codes_pkd.push(pkd);
        }else{
            angular.forEach($scope.Company.codes_pkd, function(companyPkd,index) {
                if(companyPkd.id==pkd.id){
                    $scope.Company.codes_pkd.splice(index,1);
                }
            });
        }
    }

    $scope.validationPkd = function(form){
        form.$setValidity('pkd-invalid', true, self);
        if($scope.Company.user_groups.user.market_segment){
            angular.forEach($scope.Company.user_groups.user.market_segment.codes_pkd, function(pkd){
                var valid = false;
                angular.forEach($scope.Company.codes_pkd, function(companyPkd) {
                    if(pkd.id==companyPkd.id){
                        valid = true;
                    }
                });
                if(!valid){
                    form.$setValidity('pkd-invalid', false, self);
                }
            })
        }
    }

    $scope.broadcast = function() {
        var params = {};
        params.title = 'Podpisanie umowy spółki';
        params.tokensConfirmsMessage = 'creator,'+$scope.CreatorStage.symbol;
        params.typeSubmitToken = 'ALL';

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.Company, params, $scope.methodType);
    }

    $scope.nameNumber = function(number) {
        var jednosci = ["", " jeden", " dwa", " trzy", " cztery", " pięć", " sześć", " siedem", " osiem", " dziewięć"];
        var nascie = ["", " jedenaście", " dwanaście", " trzynaście", " czternaście", " piętnaście", " szesnaście", " siedemnaście", " osiemnaście", " dziewietnaście"];
        var dziesiatki = ["", " dziesięć", " dwadzieścia", " trzydzieści", " czterdzieści", " pięćdziesiąt", " sześćdziesiąt", " siedemdziesiąt", " osiemdziesiąt", " dziewięćdziesiąt"];
        var setki = ["", " sto", " dwieście", " trzysta", " czterysta", " pięćset", " sześćset", " siedemset", " osiemset", " dziewięćset"];
        var grupy = [["" ,"" ,""],[" tysiąc" ," tysiące" ," tysięcy"],[" milion" ," miliony" ," milionów"],[" miliard"," miliardy"," miliardów"],[" bilion" ," biliony" ," bilionów"],[" biliard"," biliardy"," biliardów"],[" trylion"," tryliony"," tryliardów"]];

        if (!isNaN(number)){
            var wynik = '';
            var znak = '';
            if (number == 0) wynik = "zero";
            if (number < 0) {
                znak = "minus";
                number = number;
            }

            var g = 0;
            while (number > 0) {
                var s = Math.floor((number % 1000)/100);
                var n = 0;
                var d = Math.floor((number % 100)/10);
                var j = Math.floor(number % 10);
                if (d == 1 && j>0) {
                    n = j;
                    d = 0;
                    j = 0;
                }

                var k = 2;
                if (j == 1 && s+d+n == 0)
                    k = 0;
                if (j == 2 || j == 3 || j == 4)
                    k = 1;
                if (s+d+n+j > 0)
                    wynik = setki[s]+dziesiatki[d]+nascie[n]+jednosci[j]+grupy[g][k]+wynik;

                g++;
                number = Math.floor(number/1000);
            }
        }
        return wynik;
    }

    $scope.nameNumberL = function(number){
        var jednosci = ["", "jedenego", "dwóch", "trzech", "czterech", "pięciu", "sześciu", "siedmiu", "ośmiu", "dziewięciu", "dziesięciu"];
        return jednosci[number];
    }

    $scope.getCodesPkd = function() {
        var codes = '';
        if($scope.Company.user_groups.user.market_segment){
            angular.forEach($scope.Company.user_groups.user.market_segment.codes_pkd, function(pkd){
                codes += (pkd.symbol+' - '+pkd.title+"\r\n");
            })
        }
        return codes;
    }

    function getNextPoint(point) {
        if(!point) return $scope.CreatorStage.parts[0];
        var nextPoint = {};
        angular.forEach($scope.CreatorStage.parts, function(part, index){
            if(part.id == point.id) {
                nextPoint = ($scope.CreatorStage.parts[index+1] === undefined) ? {} : $scope.CreatorStage.parts[index+1];
            }
        });
        return nextPoint;
    }

    function hiddenControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","hidden");
        $($('.vjs-progress-control').first()).css("visibility","hidden");
    }

    function showControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","");
        $($('.vjs-progress-control').first()).css("visibility","");
    }

    function in_array(needle, haystack) {
        for(var i in haystack) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }

    $scope.correctlyChosenManagement = function() {
        return $scope.getCompanyRoleUserCount('M') > 0;
    }

}]

NotaryCtrl.getCreatorStage = function($q, $route, $rootScope, FrontCreatorStage){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorStage.get({symbol: "NOTARY"},function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

NotaryCtrl.getUsersInGroupForLoggedUser = function($q, $route, $rootScope, FrontCreatorUsersInGroupForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorUsersInGroupForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

NotaryCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

NotaryCtrl.getCompanyRoleTypes = function($q, $route, $rootScope, FrontCreatorUserCompanyRoleTypes){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorUserCompanyRoleTypes.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

NotaryCtrl.getActiveCodesPkd = function($q, $route, $rootScope, FrontCreatorCodesPkd){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCodesPkd.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}